/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.appserver;

import com.filenet.wcm.api.Session;
import filenet.sim.api.VWSIMSimulationXMLHandler;
import filenet.sim.api.VWSIMXMLOptions;
import filenet.sim.appserver.VWSIMSOAPSessionInfo;
import filenet.vw.api.VWException;
import filenet.vw.base.RetryManager;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.VWCapsule;
import filenet.vw.soap.util.VWSOAPUtils;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import simulator.ISimulator;
import simulator.publisher.IAEDataSources;
import simulator.scenario.BasicScenario;
import simulator.util.VWSIMException;

public class VWSIMSOAPService {
    public static final String PEREGRINE_SESSION = "WcmSession";
    private String m_url = "rmi://localhost:32771/WorkflowSimulator";
    private static final long m_retryTimeLimit = 10000L;
    ISimulator sim = null;
    IAEDataSources m_AEDataSources = null;
    private static Logger logger = Logger.getLogger("filenet.sim.appserver");
    private static final String m_className = "VWSIMSOAPService";
    private Hashtable m_context = new Hashtable(3);

    public VWSIMSOAPService(String url) throws SOAPException {
        if (logger.isFinest()) {
            logger.finest(m_className, "ctor", url);
        }
        if (this.sim != null) {
            return;
        }
        this.m_url = url;
        this.LookUpSimulator(null);
    }

    public void setContext(String key, Object value) {
        this.m_context.put(key, value);
    }

    public Object getContext(String key) {
        return this.m_context.get(key);
    }

    public String startSimulation(String scenarioXML, String optionsXML) throws SOAPException {
        String m_method = "startSimulation";
        logger.entering(m_className, "startSimulation");
        logger.info(m_className, "startSimulation", "optionsXML=" + optionsXML);
        try {
            this.LookUpSimulator(null);
            VWSIMXMLOptions options = VWSIMSimulationXMLHandler.parseXMLSimulationOptions(optionsXML);
            VWSIMSOAPSessionInfo ses = (VWSIMSOAPSessionInfo)this.getContext(PEREGRINE_SESSION);
            Session buzzSes = ses.getSession();
            String serverUrl = buzzSes.getRemoteServerUrl();
            String serverUploadUrl = buzzSes.getRemoteServerUploadUrl();
            String serverDownloadUrl = buzzSes.getRemoteServerDownloadUrl();
            String user = ses.getUser();
            String pw = ses.getPassword();
            if (pw == null) {
                pw = "";
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "startSimulation", "orig. user=" + user);
            }
            VWCapsule cap1 = new VWCapsule(user);
            user = cap1.getStr();
            VWCapsule cap2 = new VWCapsule(pw);
            pw = cap2.getStr();
            options.setUser(user);
            options.setPw(pw);
            options.setServerUrl(serverUrl);
            options.setServerDownloadUrl(serverDownloadUrl);
            options.setServerUploadUrl(serverUploadUrl);
            options.setPsServerUrl(this.m_url);
            StringBuffer newOptionsBuf = new StringBuffer();
            options.toXML(newOptionsBuf);
            String newOptionsXML = newOptionsBuf.toString();
            if (logger.isFinest()) {
                logger.finest(m_className, "startSimulation", newOptionsXML);
            }
            BasicScenario scn = this.newScenario(options.getSystem(), options.getRegion(), options.getName(), scenarioXML, newOptionsXML);
            return scn.id;
        }
        catch (SOAPException se) {
            throw se;
        }
        catch (Throwable ex) {
            String msg = ex == null ? "NULL" : ex.toString();
            logger.severe(m_className, "startSimulation", "propagate exception:" + msg);
            throw new SOAPException(Constants.FAULT_CODE_SERVER, msg);
        }
    }

    public void stopSimulation(String simGuid) throws SOAPException {
        String m_method = "stopSimulation:" + simGuid;
        try {
            this.LookUpSimulator(simGuid);
            this.sim.stopScenario(simGuid);
            return;
        }
        catch (SOAPException se) {
            throw se;
        }
        catch (Throwable vwe) {
            if (!(vwe instanceof VWSIMException)) {
                VWException newvwe = new VWException("sim.appserver.FailToStopSimulation", "Fail to stop simulation");
                newvwe.setCause(vwe);
                logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
                String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
                SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                throw se;
            }
            String s = VWSOAPUtils.base64ObjectSerializer(vwe);
            logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
            SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
            throw se;
        }
    }

    public int getStatus(String simGuid) throws SOAPException {
        String m_method = "getStatus:" + simGuid;
        int status = 0;
        try {
            this.LookUpSimulator(simGuid);
            status = this.sim.getScenarioSchedulerStatus(simGuid);
            if (logger.isFinest()) {
                logger.finest(m_className, "getStatus", "status=" + Integer.toString(status));
            }
            return status;
        }
        catch (SOAPException se) {
            throw se;
        }
        catch (Throwable vwe) {
            if (!(vwe instanceof VWSIMException)) {
                VWException newvwe = new VWException("sim.appserver.FailToGetScenarioStatus", "Fail to get scenario status");
                newvwe.setCause(vwe);
                logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
                String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
                SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                throw se;
            }
            String s = VWSOAPUtils.base64ObjectSerializer(vwe);
            logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
            SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
            throw se;
        }
    }

    public byte[][] readSimulationData(String simGuid, String clientIDContext, int maxRecords) throws SOAPException {
        String m_method = "readSimulationData:" + simGuid;
        try {
            this.LookUpSimulator(simGuid);
            byte[][] events = null;
            events = this.sim.readStatsData(simGuid, clientIDContext, maxRecords);
            return events;
        }
        catch (SOAPException e) {
            throw e;
        }
        catch (Throwable vwe) {
            if (!(vwe instanceof VWSIMException)) {
                VWException newvwe = new VWException("sim.appserver.FailToReadSimData", "The operation was unable to read the simulation data");
                newvwe.setCause(vwe);
                logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
                String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
                SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                throw se;
            }
            String s = VWSOAPUtils.base64ObjectSerializer(vwe);
            logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
            SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
            throw se;
        }
    }

    public void publishData(int startOrStop, String simGuid) throws SOAPException {
        String m_method = "publishData:" + simGuid;
        try {
            this.LookUpSimulator(simGuid);
            if (startOrStop != 0) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "start publishing: " + simGuid);
                }
                this.sim.startPublishScenario(simGuid);
            } else {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "stop publishing: " + simGuid);
                }
                this.sim.stopPublishScenario(simGuid);
            }
        }
        catch (SOAPException e) {
            throw e;
        }
        catch (Throwable vwe) {
            if (!(vwe instanceof VWSIMException)) {
                VWException newvwe = new VWException("sim.appserver.FailToPublishData", "Fail to {0} publishing.", startOrStop != 0 ? "start" : "stop");
                newvwe.setCause(vwe);
                logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
                String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
                SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                throw se;
            }
            String s = VWSOAPUtils.base64ObjectSerializer(vwe);
            logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
            SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
            throw se;
        }
    }

    public byte[] getPublishedSimulations(String user, byte[] token, int maxRecords) throws SOAPException {
        String m_method = "getPublishedSimulations";
        try {
            this.LookUpSimulator(null);
            this.getAEDataSources();
            return this.getPublishedSimulations1(user, token, maxRecords);
        }
        catch (SOAPException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = e == null ? "NULL" : e.toString();
            logger.severe(m_className, m_method, "propagate exception:" + msg);
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "getPublishedSimulation exception: " + e.getMessage());
        }
    }

    public void deletePublishedData(byte[] publishedSimulations) throws SOAPException {
        String m_method = "deletePublishedData";
        try {
            if (this.m_AEDataSources == null) {
                this.LookUpSimulator(null);
                this.getAEDataSources();
            }
            this.deletePublishedData1(publishedSimulations);
        }
        catch (SOAPException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = e == null ? "NULL" : e.toString();
            logger.severe(m_className, m_method, "propagate exception:" + msg);
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "deletePublishedData exception: " + e.getMessage());
        }
    }

    public void setSimEngUrl(String url) {
        this.m_url = url;
    }

    public String getStatistics(String simGuid) throws SOAPException {
        String m_method = "getStatistics:" + simGuid;
        String stats = null;
        try {
            this.LookUpSimulator(simGuid);
            stats = this.sim.getSimStatisticsInfo(simGuid);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "stats=" + stats);
            }
            return stats;
        }
        catch (SOAPException se) {
            throw se;
        }
        catch (Throwable vwe) {
            if (!(vwe instanceof VWSIMException)) {
                VWException newvwe = new VWException("sim.appserver.FailToGetScenarioStatistics", "Fail to get scenario statistics.");
                newvwe.setCause(vwe);
                logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
                String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
                SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                throw se;
            }
            String s = VWSOAPUtils.base64ObjectSerializer(vwe);
            logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
            SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
            throw se;
        }
    }

    protected void finalize() {
        this.cleanupEx();
    }

    public void cleanup() {
    }

    public void cleanupEx() {
        logger.entering(m_className, "CleanupEx");
        this.sim = null;
        this.m_AEDataSources = null;
        logger.exiting(m_className, "CleanupEx");
    }

    private void LookUpSimulator(String simGuid) throws SOAPException {
        String m_method = "LookUpSimulator";
        RetryManager retry = new RetryManager(10000L);
        Exception vwe = null;
        do {
            try {
                String url = this.m_url;
                if (simGuid != null) {
                    int indexOf = simGuid.indexOf("[__]");
                    if (indexOf == -1) {
                        VWException newvwe = new VWException("sim.appserver.InvalidId", "{0} is not a valid simulation id", simGuid);
                        logger.severe(m_className, m_method, "throwing exception: " + newvwe.getMessage());
                        String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
                        SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                        throw se;
                    }
                    url = "rmi://" + simGuid.substring(0, indexOf) + "/WorkflowSimulator";
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, url);
                }
                this.sim = (ISimulator)Naming.lookup(url);
                return;
            }
            catch (NotBoundException e) {
                retry.setCauseObj(e);
            }
            catch (AccessException e) {
                retry.setCauseObj(e);
            }
            catch (MalformedURLException e) {
                vwe = e;
                break;
            }
            catch (RemoteException e) {
                retry.setCauseObj(e);
            }
            catch (Exception e) {
                vwe = e;
                break;
            }
        } while (retry.again());
        if (vwe != null && vwe instanceof SOAPException) {
            throw (SOAPException)((Object)vwe);
        }
        if (vwe == null) {
            vwe = (Exception)retry.getCauseObj();
        }
        if (!(vwe instanceof VWSIMException)) {
            VWException newvwe = new VWException("sim.appserver.FailToLookUpSimulator", "Cannot connect to the Process Simulator. Please make sure the Process Simulator is running.");
            newvwe.setCause(vwe);
            logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
            String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
            SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
            throw se;
        }
        String s = VWSOAPUtils.base64ObjectSerializer(vwe);
        logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
        SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
        throw se;
    }

    private BasicScenario newScenario(String system, int region, String simulationName, String scenarioXML, String filenetOptionsXML) throws Exception {
        String m_method = "newScenario";
        logger.entering(m_className, "newScenario");
        try {
            String user = null;
            VWSIMSOAPSessionInfo ses = null;
            try {
                ses = (VWSIMSOAPSessionInfo)this.getContext(PEREGRINE_SESSION);
            }
            catch (Exception e) {
                logger.info(m_className, "newScenario", "getVWSIMSOAPSessionInfo failed");
                ses = null;
            }
            if (ses != null) {
                try {
                    user = ses.getUser();
                }
                catch (Exception e) {
                    user = null;
                    logger.info(m_className, "newScenario", "get user failed");
                }
            }
            if (user == null) {
                user = "Unknown";
            }
            logger.info(m_className, "newScenario", user + simulationName);
            BasicScenario scn = this.sim.newScenario(system, region, simulationName, user, scenarioXML, filenetOptionsXML);
            return scn;
        }
        catch (Throwable vwe) {
            if (!(vwe instanceof VWSIMException)) {
                VWException newvwe = new VWException("sim.appserver.FailToNewScenario", "Failed to create scenario: {0}", vwe.getMessage());
                newvwe.setCause(vwe);
                logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
                String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
                SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                throw se;
            }
            String s = VWSOAPUtils.base64ObjectSerializer(vwe);
            logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
            SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
            throw se;
        }
    }

    private void getAEDataSources() throws Exception {
        String m_method = "getAEDataSources";
        try {
            this.m_AEDataSources = this.sim.getAEDataSources();
        }
        catch (Throwable vwe) {
            if (!(vwe instanceof VWSIMException)) {
                VWException newvwe = new VWException("sim.appserver.FailToGetDataSources", "Fail to get PA datasources");
                newvwe.setCause(vwe);
                logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
                String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
                SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                throw se;
            }
            String s = VWSOAPUtils.base64ObjectSerializer(vwe);
            logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
            SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
            throw se;
        }
    }

    private byte[] getPublishedSimulations1(String user, byte[] token, int maxRecords) throws Exception {
        String m_method = "getPublishedSimulations1";
        if (token == null) {
            try {
                return this.m_AEDataSources.queryDataSources(user, maxRecords);
            }
            catch (Throwable vwe) {
                if (!(vwe instanceof VWSIMException)) {
                    VWException newvwe = new VWException("sim.appserver.FailToGetPublishedData", "Fail to get published data");
                    newvwe.setCause(vwe);
                    logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
                    String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
                    SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                    throw se;
                }
                String s = VWSOAPUtils.base64ObjectSerializer(vwe);
                logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
                SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                throw se;
            }
        }
        try {
            return this.m_AEDataSources.queryNext(token, maxRecords);
        }
        catch (Throwable vwe) {
            if (!(vwe instanceof VWSIMException)) {
                VWException newvwe = new VWException("sim.appserver.FailToGetPublishedData", "Fail to get published data");
                newvwe.setCause(vwe);
                logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
                String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
                SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                throw se;
            }
            String s = VWSOAPUtils.base64ObjectSerializer(vwe);
            logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
            SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
            throw se;
        }
    }

    private void deletePublishedData1(byte[] publishedSimulations) throws Exception {
        String m_method = "deletePublishedData1";
        try {
            this.m_AEDataSources.deletePublishedData(publishedSimulations);
            return;
        }
        catch (Throwable vwe) {
            if (!(vwe instanceof VWSIMException)) {
                VWException newvwe = new VWException("sim.appserver.FailToDeletePublishedData", "Fail to delete published data");
                newvwe.setCause(vwe);
                logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
                String s = VWSOAPUtils.base64ObjectSerializer(newvwe);
                SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
                throw se;
            }
            String s = VWSOAPUtils.base64ObjectSerializer(vwe);
            logger.severe(m_className, m_method, "Got: " + vwe.getClass().getName() + ", msg=" + vwe.getMessage());
            SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s);
            throw se;
        }
    }
}

